﻿var quotas = {
    inPercent: $("#InPercent").val() == "True",
    canModifyQuotas: $("#CanModifyQuotas").val() == "True",
    canModifyQuotaDefinitions: $("#CanModifyQuotaDefinitions").val() == "True",
    context: $(".v-quotas"),
    treeview: null,
    datatable: null,
    initializeTreeView: function () {
        var actionButtons = [];

        if (quotas.canModifyQuotas) {
            actionButtons = [{ Action: "copyfrom", Label: resources.CopyStrataFrom, Icon: "copy", "DisplayCondition": function (data) { return data.Type == 'user'; } }];
        }

        this.treeview = $(".h-userGroups", this.context).a4listview({
            ajaxAction: a4.getSurveyAction("GetUserGroupsAndUsers", "Offline"),
            customItems: [
                { Action: "all", Name: resources.All },
            ],
            icons: {
                Node: null,
                Leaf: "user"
            },
            properties: {
                Children: "Users"
            },
            selectNode: function (event, data) {
                quotas.refreshTable(data);
            },
            actionButtons: actionButtons,
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "copyfrom":
                        modalDialog.showWindow(a4.getSurveyAction("CopyUserStrata", "Offline", { userId: node.Id }), 400, 500, { afterClose: function () { quotas.refreshContent(); } });
                        break;
                }
            },
            draw: function (event, data) {
                if (quotas.datatable) {
                    quotas.refreshTable(data);
                }
                else {
                    quotas.initializeDataTable();
                }
            },
            localizableTexts: { "Search": resources.SearchUsers }
        });
    },
    initializeDataTable: function () {
        var objectiveSuffix = null;
        var objectiveColumn = "Objective";

        if (quotas.inPercent) {
            objectiveSuffix = "%";
            objectiveColumn = "ObjectivePercentage";
        }

        var toolBarItems = [];
        var contextMenuItems = [];

        if (quotas.canModifyQuotas) {
            toolBarItems = [
                { "Action": "modify", "Label": resources.ModifyUserQuota },
                { "Action": "open", "Label": resources.Open, "DisplayCondition": function (data) { return data.Status != 2; } },
                { "Action": "close", "Label": resources.Close, "DisplayCondition": function (data) { return data.Status != 2; } }
            ];

            contextMenuItems = [
                { "Action": "properties", "Label": resources.Properties },
                { "Divider": true },
                { "Action": "open", "Label": resources.Open, "DisplayCondition": function (data) { return data.Status != 2 && data.UserStatus != 0; } },
                { "Action": "close", "Label": resources.Close, "DisplayCondition": function (data) { return data.UserStatus != 2; } }
            ];
        }

        this.datatable = $(".h-quotasTable", quotas.context).a4datatable({
            advancedFilter: true,
            stateKey: "UserQuotas",
            ajaxAction: a4.getSurveyAction("GetStrata", "Offline"),
            columns: [            
                { "Name": "UserName", "Title": resources.User },
                { "Name": "Position", "Title": resources.Stratum },
                { "Name": "Status", "Data": "StatusEnum", "Title": resources.Status, "Type": "enum", "EnumType": "QuotaStatus"},
                { "Name": "Criterion", "Title": resources.Criterion },
                { "Name": "Label", "Title": resources.Label },
                { "Name": "Objective", "Data": objectiveColumn, "Title": resources.Objective, "Type": "numeric", "Suffix": objectiveSuffix },
                { "Name": "Completed", "Title": resources.Completed },
                { "Name": "ToDo", "Title": resources.ToDo },
                { "Name": "UserStatus", "Data": "UserStatusEnum", "Title": resources.UserStatus, "Type": "enum", "EnumType": "QuotaStatus", "Editable": quotas.canModifyQuotas },
                { "Name": "UserObjective", "Title": resources.UserObjective, "Type": "numeric", "Suffix": objectiveSuffix, "Editable": quotas.canModifyQuotas },
                { "Name": "UserCompleted", "Title": resources.UserCompleted },
                { "Name": "UserToDo", "Title": resources.UserToDo }
            ],
            localizableTexts: { "All": resources.AllStrata, "Search": resources.SearchStrata },
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                switch (action) {
                    case "modify":
                        modalDialog.showWindow(a4.getSurveyAction("ModifyObjectives", "Offline"), 200, 500);
                        break;
                    case "open":
                        quotas.updateStrataStatus(rows, 0);
                        break;
                    case "close":
                        quotas.updateStrataStatus(rows, 2);
                        break;
                };
            },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "open":
                        quotas.updateStrataStatus([row], 0);
                        break;
                    case "close":
                        quotas.updateStrataStatus([row], 2);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getSurveyAction("StratumProperties", "Offline", { userId: row.UserId, stratumId: row.StratumId }), 400, null, { afterClose: function () { quotas.refreshContent(true); } });
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.StatusOpen, "AjaxParams": { "status": 0 } },
                    { "Label": resources.StatusClosed, "AjaxParams": { "status": 2 } }
                ]
            },            
            draw: function () {
                a4.callServerMethod(a4.getSurveyAction("GetOutdatedStrataCount", "Quotas"), {}, function (result) {
                    $(".v-outdatedStrataPanel", quotas.context).toggle(result > 0);
                    $(".v-outdatedStrataCount", quotas.context).text(result);
                });
            },
            multiEdit: quotas.canModifyQuotas,
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getSurveyAction("UpdateStrata", "Offline"), { strata: data.rows }, function () { data.multiEditSaveCallback(); });
            },
            cellCreated: function (evt, data) {
                if (data.fieldName == "UserStatus")
                    $(data.cell).addClass("stratum-status-" + data.row.UserStatus);
                else
                    if (data.fieldName == "Status")
                        $(data.cell).addClass("stratum-status-" + data.row.Status);
            }

        });
    },
    refreshContent: function () {
        this.treeview.a4listview("refresh");
    },
    refreshTable: function (treeViewData) {
        var tableParams = {};

        if (treeViewData.isCustom) {
            tableParams.userOrGroup = null;
            tableParams.userOrGroupId = null;
        }
        else if (treeViewData.node) {
            tableParams.userOrGroup = treeViewData.node.Type;
            tableParams.userOrGroupId = treeViewData.node.Id;
        }

        quotas.datatable.a4datatable("option", "ajaxParams", tableParams);
        quotas.datatable.a4datatable("refresh", true);
    },
    bindEvents: function () {
        this.context.on("click", ".h-exportStrata", function () {
            var tableParams = quotas.datatable.a4datatable("getTableParams");

            a4.showBusyBox();

            a4.callServerMethod(a4.getSurveyAction("ExportStrata", "Offline"), { tableParams: JSON.stringify(tableParams) }, function (result) {
                a4.hideBusyBox();
                window.location = a4.getSurveyAction("GetStrataFile", "Offline", { fileName: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });

        this.context.on("click", ".h-importQuotas", function () {
            modalDialog.showWindow(a4.getSurveyAction("ImportStrata", "Offline"), 450, null, { afterClose: function () { quotas.refreshContent(true); } });
        });

        surveyMenu.onAfterRefresh = function () {
            quotas.refreshContent();
        };
    },
    updateStrataStatus: function (strata, status) {
        a4.callServerMethod(a4.getSurveyAction("UpdateStrataStatus", "Offline"), { strata: strata, status: status }, function (result) {
            quotas.refreshContent();
        });
    },
    updateStrataObjectives: function (objective) {
        if (objective) {
            var rows = quotas.datatable.a4datatable("getSelectedItems");
            a4.callServerMethod(a4.getSurveyAction("UpdateStrataObjectives", "Offline"), { strata: rows, objective: objective }, function (result) {
                quotas.refreshContent();
            });
        }
    },
}

$(document).ready(function () {
    if (quotas.context.length > 0) {
        quotas.initializeTreeView();
        quotas.bindEvents();
    }
});


